<?php

use App\Models\User;
use Illuminate\Support\Facades\Log;

use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\OtpController;

use Illuminate\Support\Facades\Session;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\OrderController;


use App\Http\Controllers\PaperController;

use App\Http\Controllers\StaffController;
use App\Http\Controllers\PayPalController;

use App\Http\Controllers\PaymentController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\RazorpayController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return redirect()->route('login');
});

Route::get('paper-submission', function () {
    return view('privacy-policy');
})->name('paper-submission');
Route::post('/submit-paper', [PaymentController::class, 'submitPaper'])->name('paper.submit');
Route::post('/paper/payment', [PaymentController::class, 'processPayment'])->name('payment.process');
Route::post('/payment-callback', [PaymentController::class, 'paymentCallback'])->name('payment.callback')->withoutMiddleware(['auth', 'guest']);
Route::get('/payment-success', function () {
    return view('payment.success', [
        'success' => Session::get('success'),
        'transaction_id' => Session::get('transaction_id'),
        'amount' => Session::get('amount'),
        'status' => Session::get('status'),
    ]);
})->name('paper.success');

Route::get('/payment-failure', function () {
    return view(
        'payment.failure'
        // , [

        //     'amount' => Session::get('amount'),
        //     'status' => Session::get('status'),
        //     'error' => Session::get('error'),
        // ]
    );
})->name('paper.failure');
Route::get('submit-paper', [PaperController::class, 'showForm'])->name('paper.form')->middleware('auth');
// Route::post('submit-paper', [PaperController::class, 'submitPaper'])->name('paper.submit');
Route::get('privacy-policy', function () {
    return view('privacy-policy');
})->name('privacy-policy');



require __DIR__ . '/auth.php';

Route::get('/test-session', function () {
    $paperDetails = Session::get('paper_details');
    Log::info('Test session details: ', (array) $paperDetails);
    return response()->json($paperDetails);
});
// profile route for use all users
Route::group(['prefix' => '/update-account-details', 'as' => 'admin.', 'middleware' => ['auth']], function () {
    Route::resource('/profile', ProfileController::class);
    Route::patch('/store-token', [NotificationController::class, 'updateDeviceToken'])->name('store.token');

    Route::get('/fetch-notifications', [NotificationController::class, 'fetchNotifications']);
    Route::post('/clear-notifications', [NotificationController::class, 'clearNotifications']);
});
Route::get('/home', function () {
    return view('guest.dashboard');
})->name('guest-home');




//  notification testing ==========
Route::get('push-notification', [NotificationController::class, 'index']);
Route::post('sendNotification', [NotificationController::class, 'sendNotification'])->name('send.notification');
// =====================
Route::group([ 'middleware' => ['auth']], function () {
Route::get('/users', [HomeController::class, 'index']);
Route::post('/user-status', [HomeController::class, 'userStatus'])->name('user.status');

Route::get('/papers', [OrderController::class, 'index'])->name('orders');
Route::get('/quantity-manage', [OrderController::class, 'quantityManage']);
Route::post('/quantity-manage', [OrderController::class, 'lessQty'])->name('store.table.data');
Route::get('/show-orderdetail', [OrderController::class, 'viewOrderDetail'])->name('show-orderdetail');

Route::get('/paper-submission/{id}', [OrderController::class, 'getPaperSubmission'])->name('get-paper-submission');


Route::put('/paper-update/{id}', [OrderController::class, 'updatePaper'])->name('paper.update');
Route::get('/generate-certificate/{id}', [OrderController::class, 'generateCertificate'])->name('generate.certificate');
Route::get('/viewcertificates', [OrderController::class, 'viewcertificates'])->name('viewcertificates');

});

Route::get('payment', 'PayPalController@payment')->name('payment');

Route::get('cancel', 'PayPalController@cancel')->name('payment.cancel');

Route::get('payment/success', 'PayPalController@success')->name('payment.success');




Route::get('/update-password', function () {
    $users = User::where('role_id', '!=', null)->get();
    foreach ($users as $key => $value) {
        // return $value;
        $value->update(['password' => Hash::make($value->mobile)]);
    }
    return $users;
});


Route::get('/test-pay', function () {
    return 'Test Pay Route - No auth required!';
})->withoutMiddleware(['auth', 'guest'])->name('test.pay');
Route::get('/pay', [PayPalController::class, 'createTransaction'])->withoutMiddleware(['auth', 'guest'])
    ->name('paypal.create');


Route::get('/success', [PayPalController::class, 'successTransaction'])
    ->name('paypal.success')
    ->withoutMiddleware(['auth', 'guest']);

Route::get('/cancel', [PayPalController::class, 'cancelTransaction'])
    ->name('paypal.cancel')
    ->withoutMiddleware(['auth', 'guest']);
Route::middleware(['web'])->group(function () {});


Route::get('/test', function () {

    return view('certificate');
});

Route::group(['prefix' => '/admin', 'as' => 'admin.', 'middleware' => ['auth', 'admin']], function () {
    Route::get('/dashboard', [HomeController::class, 'AdminHome'])->name('dashboard');
});

// staff route
/*************  ✨ Windsurf Command ⭐  *************/
Route::group(['middleware' => ['auth', 'admin']], function () {

    Route::resource('staff', StaffController::class)->middleware('auth');
    Route::post('/staff-status', [StaffController::class, 'change_status'])->name('staff.status');
    Route::post('/assign-reviewers', [PaperController::class, 'assignReviewers'])->name('papers.assignReviewers');
    /*******  79fa286c-7599-4259-9f36-449371fc3e9a  *******/
    Route::post('/update-paper-status', [PaperController::class, 'updatePaperStatus'])->name('update-paper-status');

Route::get('/reviewer/change-password',
    [StaffController::class, 'changePasswordForm']
)->name('reviewer.password.form');

Route::post('/reviewer/change-password',
    [StaffController::class, 'updatePassword']
)->name('reviewer.password.update');
    Route::post('/withdraw-paper', [PaperController::class, 'withdrawPaper'])->name('withdraw.paper');

    Route::post('/paper-copyright', [PaperController::class, 'paperCopyright'])->name('paper.copyright');

    Route::post('/admin-paper-status', [PaperController::class, 'updatePaperStatusByAdmin'])->name('papers.updateStatus');
    // use Illuminate\Support\Str;

    Route::post('/camera-ready/{id}', [PaperController::class, 'cameraReady'])->name('camera.ready');
    Route::get('/camera-ready-papers', [PaperController::class, 'cameraReadyPapers'])->name('camera.ready.papers');
Route::get('/payment/{id}', [PaymentController::class, 'paperPayment'])->name('payment');

Route::get('/withdraw-papers', [PaperController::class, 'withdrawPapers'])->name('withdraw.papers');


Route::post('/reviewer-certificates/generate', [PaperController::class, 'generateReviewerCertificates'])->name('reviewer.certificates');



});
Route::post('/send-otp', [OtpController::class, 'sendOtp'])->name('send.otp');
Route::post('/verify-otp', [OtpController::class, 'verifyOtp'])->name('verify.otp');

Route::post('/register-send-otp', [OtpController::class, 'sendOtp'])->name('register.send-otp');
Route::post('/register-verify-otp', [OtpController::class, 'verifyOtp'])->name('register.verify-otp');


Route::get('/get-papers-by-user/{userId}', [PaperController::class, 'getPapersByUser']);



// Route::post('payment-success', [RazorpayController::class, 'paymentSuccess']);
Route::get('/razorpay/callback', [RazorpayController::class, 'callback'])->name('razorpay.callback');
